;*** Misc

Declare Resize_mainwindow()
;-pack
Procedure unloadpackmem()
  If loadpackmemadr
    FreeMemory(0)
    loadpackmemadr=0
  EndIf
EndProcedure
Procedure loadpackmem(adr1)
  If loadpackmemadr
    unloadpackmem()
  EndIf
  len=PeekL(adr1):adr1+4
  loadpackmemadr=AllocateMemory(0,len)
  UnpackMemory(adr1,loadpackmemadr)
  ProcedureReturn loadpackmemadr
EndProcedure
Procedure CatchPackImage(spr,adr)
  CatchImage(spr,loadpackmem(adr))
  unloadpackmem()
EndProcedure
;-message
;-open message 
      
If OpenWindow(#window_message, 0,0, 200,60, #PB_Window_ScreenCentered|#PB_Window_Invisible,#title_main)
  If CreateGadgetList(WindowID())
    TextGadget(#gadget_message_text1, 5,10, 190,20,"",#PB_Text_center)
    TextGadget(#gadget_message_text2, 5,30, 190,20,"",#PB_Text_center)
  EndIf
  setwindowpos_(WindowID(),#hwnd_topmost,WindowX(),WindowY(),-1,-1,#SWP_NOSIZE |#SWP_SHOWWINDOW)
  ;i=getwindowlong_(WindowID(),#gwl_exstyle)
  ;SetWindowLong_(WindowID(),#GWL_EXSTYLE,I|#WS_EX_TOOLWINDOW)
EndIf

Procedure hide_message()
  HideWindow(#window_message,1)
EndProcedure

Procedure set_message(text1$,text2$)
  HideWindow(#window_message,0)
  UseWindow(#window_message)
  ActivateWindow()
  SetGadgetText(#gadget_message_text1,text1$)
  SetGadgetText(#gadget_message_text2,text2$)
EndProcedure

Procedure set_submessage(text2$)
  SetGadgetText(#gadget_message_text2,text2$)
EndProcedure
;-peekub
Procedure peekub(adr)
  b=PeekB(adr)
  If b<0: b=b+256 :EndIf
  ProcedureReturn b
EndProcedure

;-scrollgadget
; CreateScrollGadget(Scroll_ID, x, y, Width, Height, SizeX, SizeY, Flags, WindowID) 
; --------------------------------------------------------------------------------- 
; Scroll_ID   : Die Benutzerdefinierte ID des ScrollGadget (wird zusammen mit SetScrollGadget() benutzt) 
; x, y     : Die Position des bergeordneten Fensters 
; Width, Height : Hhe und Breite des ScrollGadgets (dies schliet die Bildlaufleisten und Rahmen mit ein) 
; SizeX, SizeY : Die Hhe und Breite des scrollbaren Bereichs. 
; Flags     : Einige Optionen zum Steuern des Aussehens des ScrollGadgets (s.u.) 
; WindowID   : Das Handle des Fensters in welchem das ScrollGadgets erstellt werden soll 

; Options for the Flags-Parameter: 
;  #ScrollBar_NoScrollH  : Eine horizontale Bildlaufleiste wird auf keinen Fall dargestellt 
;  #ScrollBar_NoScrollV  : Eine vertikale          -"- 
;  #ScrollBar_Border   : Gibt dem scrollbaren Bereich eine dnne (2D) Begrenzungslinie 
;  #ScrollBar_ThickBorder :        -"-      einen dicken 3D-Rahmen 
;  #ScrollBar_Left    : Die vertikale Bildlaufleiste wird auf der linken Seite dargestellt 
;  #ScrollBar_Top     : Die horizontale Bildlaufleiste wird oberhalb des scrollbaren Bereichs 
;              dargestellt 
; --------------------------------------------------------------------------------- 

; SetScrollGadget(Scroll_ID, X, Y, Width, Height, ClientW, ClientH) 
; ----------------------------------------------------------------- 
; Scroll_ID   : Die benutzerdefinierte ID des ScrollGadget (welche bei der Erzeugung angegeben wurde) 
; X, Y     : Die neue Position auf dem bergeordneten Fenster * 
; Width, Height : Die neue Hhe und Breite des ScrollGadgets * 
; SizeX, SizeY : Die neue Hhe und Breite des scrollbaren Bereichs * 
; 
; CloseScrollGadget() 
; ------------------- 
; Diese Funktion muss aufgerufen werden um die Erstellung des ScrollGadgets abzuschlieen. 
; Gadgets welche zwischen der Erzeugung und dem Abschlu erzeugt wurden, werden innerhalb 
; des ScrollGadgets dargestellt. 

; HideScrollGadget(Scroll_ID,Hide)
; --------------------------------
; Hide=0 sichtbar =1 unsichtbar
;
; DeleteScrollGadget(Scroll_ID)
; -----------------------------
; Lscht das ScrollGadget


Structure ScrollInfo2 
;##### Fixed Data ##### 
 *Previous.l 
 Scroll_ID.l 
 ;Window Handles 
 hEnv.l  ; Envelope Window 
 hPB.l    ; Window 
 hWindow.l 
 hScrollV.l 
 hScrollH.l 
 ;Flags for the Look and Feel of the ScrollGadget 
 Flags.l 

;##### Variable Data ##### 
 ;Position of the ScrollGadget on Parent Window 
 X.l 
 Y.l 

 ;Size of the ScrollGadget (including the ScrollBars and Borders) 
 Width.l 
 Height.l 
 
 ;Position of the ClientArea in Envelope Window 
 PosX.l 
 PosY.l 

 ;Minimum Size of ClientArea 
 ClientW.l 
 ClientH.l 
 ;Actual Size of ClientArea (May differ when PageSize < [GadgetSize - ScrollBars - Borders] ) 
 SizeX.l 
 SizeY.l 
 
 ;Size of the visible Part of ClientArea 
 VisW.l 
 VisH.l
 
 ;hideflags
 hide.l
 hideV.l
 hideH.l
EndStructure 
NewList ScrollGadgets.ScrollInfo2() 

; Some more declarations (constants and forward-declaration of functions) 
Declare CreateScrollGadget(Scroll_ID, x, y, Width, Height, SizeX, SizeY, Flags, WindowID) 
Declare SetScrollGadget(Scroll_ID, X, Y, Width, Height, ClientW, ClientH) 
Declare CloseScrollGadget() 
Declare WindowCallback(WindowID, Message, wParam, lParam) 

;constants 
#NULL=0 
#FALSE=0 
#TRUE=1

#ScrollBar_NoScrollH  = 1 
#ScrollBar_NoScrollV  = 2 
#ScrollBar_Border   = 4 
#ScrollBar_ThickBorder = 8 
#ScrollBar_Left    = 16 
#ScrollBar_Top     = 32 
; ######################################################################################################## 
; ScrollGadget-Procedures 
Procedure CreateScrollGadget(Scroll_ID, x, y, Width, Height, ClientW, ClientH, Flags, WindowID) 
 Protected WinFlag.l, Previous.l 

 If Flags & #ScrollBar_Border 
  WinFlag = #WS_CHILD | #WS_VISIBLE | #WS_BORDER 
 ElseIf Flags & #ScrollBar_ThickBorder 
  WinFlag = #WS_CHILD | #WS_VISIBLE | #WS_THICKFRAME 
 Else 
  WinFlag = #WS_CHILD | #WS_VISIBLE 
 EndIf 

 Previous = @ScrollGadgets() 
 ;Generating new listentry 
 AddElement(ScrollGadgets()) 

;###### STORING THE RAWDATA ###### 
 ;Userdefined ID 
 ScrollGadgets()\Scroll_ID = Scroll_ID 
 ;Pointer to Previous ScrollGadget in list 
 ScrollGadgets()\Previous = Previous 
 ;Gadget Data 
 ScrollGadgets()\X = x : ScrollGadgets()\Y = y 
 ScrollGadgets()\Width = Width : ScrollGadgets()\Height = Height 
 ScrollGadgets()\Flags = Flags 

 ;Client Data 
 ScrollGadgets()\PosX = 1 : ScrollGadgets()\PosY = 1 
 ScrollGadgets()\ClientW = ClientW : ScrollGadgets()\ClientH = ClientH 

;###### CREATING THE WINDOWS ###### 
 ;Parent-Window 
 ScrollGadgets()\hPB = WindowID 
 ;Envelope-Window 
 ScrollGadgets()\hEnv = CreateWindowEx_(0, "Static", "", WinFlag, 0, 0, 0, 0, WindowID, 0, GetModuleHandle_(0), 0) 
 ;Client-Area 
 ScrollGadgets()\hWindow = CreateWindowEx_(0, "Static", "", #WS_CHILD | #WS_VISIBLE, 0, 0, 0, 0, ScrollGadgets()\hEnv, 0, GetModuleHandle_(0), 0) 
 ;ScrollBars 
 ScrollGadgets()\hScrollV = CreateWindowEx_(0, "ScrollBar", "", #WS_CHILD | #WS_VISIBLE | #SBS_VERT | #SBS_LEFTALIGN, 0, 0, 0, 0, WindowID, 0, GetModuleHandle_(0), 0)  
 ScrollGadgets()\hScrollH = CreateWindowEx_(0, "ScrollBar", "", #WS_CHILD | #WS_VISIBLE | #SBS_HORZ | #SBS_TOPALIGN, 0, 0, 0, 0, WindowID, 0, GetModuleHandle_(0), 0) 
 
 SetScrollGadget(Scroll_ID, -1, -1, -1, -1, -1, -1) 

 CreateGadgetList(ScrollGadgets()\hWindow) 
 SetWindowCallback(@WindowCallback()) 
 SetWindowLong_(ScrollGadgets()\hWindow, #GWL_WNDPROC, GetWindowLong_(WindowID(), #GWL_WNDPROC)) 

 ProcedureReturn ScrollGadgets()\hWindow 
EndProcedure 
Procedure UseScrollGadgetList(scroll_id)
  ResetList(ScrollGadgets()) 
  Repeat 
    ne = NextElement(ScrollGadgets()) 
    If ne = #NULL :   ProcedureReturn #FALSE :  EndIf 
  Until (ScrollGadgets()\Scroll_ID = Scroll_ID)

  UseGadgetList(ScrollGadgets()\hWindow)
EndProcedure
Procedure HideScrollGadget(scroll_id,x)
  ResetList(ScrollGadgets()) 
  Repeat 
    ne = NextElement(ScrollGadgets()) 
    If ne = #NULL :   ProcedureReturn #FALSE :  EndIf 
  Until (ScrollGadgets()\Scroll_ID = Scroll_ID)
  ScrollGadgets()\hide=X
  EnableWindow_(ScrollGadgets()\hEnv,1-X)
  If x:x=#SW_HIDE:Else:x=#SW_SHOWNA:EndIf
  showwindow_(ScrollGadgets()\hEnv,X)
  showwindow_(ScrollGadgets()\hWindow,X)
  If scrollgadgets()\hideV : showwindow_(ScrollGadgets()\hScrollV,x) : EndIf
  If scrollgadgets()\hideH : showwindow_(ScrollGadgets()\hScrollH,x) : EndIf
  ProcedureReturn #true 
EndProcedure
Procedure DeleteScrollGadget(scroll_id)
  ResetList(ScrollGadgets()) 
  Repeat 
    ne = NextElement(ScrollGadgets()) 
    If ne = #NULL :   ProcedureReturn #FALSE :  EndIf 
  Until (ScrollGadgets()\Scroll_ID = Scroll_ID)

  destroywindow_(ScrollGadgets()\hEnv)
  destroywindow_(ScrollGadgets()\hWindow)
  destroywindow_(ScrollGadgets()\hScrollV)
  destroywindow_(ScrollGadgets()\hScrollH)
  
  DeleteElement(scrollgadgets())
  
  ProcedureReturn #true 
EndProcedure
Procedure SetScrollGadget(Scroll_ID, X, Y, Width, Height, ClientW, ClientH) 

 Protected Flags.l, WinFlag.l, BorderW.l, BorderH.l, ScrollBarW.l, ScrollBarH.l 
 Protected WEnvW.l, XEnvW.l, HEnvW.l, YEnvW.l, YScr.l, XScr.l, params.SCROLLINFO 

 ;Retrieving the Gadget with the right ID 
 ResetList(ScrollGadgets()) 
 Repeat 
  ne = NextElement(ScrollGadgets()) 
  If ne = #NULL :   ProcedureReturn #FALSE :  EndIf 
 Until (ScrollGadgets()\Scroll_ID = Scroll_ID) 

 ScrollBarW = GetSystemMetrics_(#SM_CXVSCROLL) : ScrollBarH = GetSystemMetrics_(#SM_CYVSCROLL) 
 
 Flags = ScrollGadgets()\Flags 
 
 ScrollGadgets()\PosX = 1
 ScrollGadgets()\PosY = 1

 
 If Flags & #ScrollBar_Border 
  WinFlag = #WS_CHILD | #WS_VISIBLE | #WS_BORDER 
  BorderW = GetSystemMetrics_(#SM_CXBORDER) : BorderH = GetSystemMetrics_(#SM_CYBORDER) 
 ElseIf Flags & #ScrollBar_ThickBorder 
  WinFlag = #WS_CHILD | #WS_VISIBLE | #WS_THICKFRAME 
  BorderW = GetSystemMetrics_(#SM_CXFIXEDFRAME) : BorderH = GetSystemMetrics_(#SM_CYFIXEDFRAME) 
 Else 
  WinFlag = #WS_CHILD | #WS_VISIBLE 
  BorderW = 0 : BorderH = 0 
 EndIf 

 ; Check if the dimensions have changed 
 If X <> -1 : ScrollGadgets()\X = X : Else : X = ScrollGadgets()\X : EndIf 
 If Y <> -1 : ScrollGadgets()\Y = Y : Else : Y = ScrollGadgets()\Y : EndIf 
 If ClientW <> -1 : ScrollGadgets()\ClientW = ClientW : Else : ClientW = ScrollGadgets()\ClientW : EndIf
 If ClientH <> -1 : ScrollGadgets()\ClientH = ClientH : Else : ClientH = ScrollGadgets()\ClientH : EndIf
 If Width <>-1 : ScrollGadgets()\Width = Width : Else : Width = ScrollGadgets()\Width : EndIf 
 If Height<>-1 : ScrollGadgets()\Height = Height : Else : Height = ScrollGadgets()\Height : EndIf 


 If(ClientW > (Width - (2 * BorderW))) And (Flags & #ScrollBar_NoScrollH = 0) : sbHActive.b = #TRUE : Else : sbHActive.b = #FALSE : EndIf 
 If(ClientH > (Height - (2 * BorderH))) And (Flags & #ScrollBar_NoScrollV = 0) : sbVActive.b = #TRUE : Else : sbVActive.b = #FALSE : EndIf 
 If(sbHActive) And (Flags & #ScrollBar_NoScrollV = 0) 
  If(ClientH > (Height - (2 * BorderH) ) - ScrollBarH) : sbVActive = #TRUE : Else : sbVActive = #FALSE : EndIf 
 EndIf 
 If(sbVActive) And (Flags & #ScrollBar_NoScrollH = 0) 
  If(ClientW > (Width - (2 * BorderW) ) - ScrollBarW) : sbHActive = #TRUE : Else : sbHActive = #FALSE : EndIf 
 EndIf 
 If sbVActive 
  If(Flags & #ScrollBar_Left)>0 : XEnvW = X + ScrollBarW : XScr = X : Else : XEnvW = X : XScr = X + Width - ScrollBarW : EndIf 
  WEnvW = Width - ScrollBarW 
 Else : XEnvW = X : XScr = X : WEnvW = Width : EndIf 
 If sbHActive 
  If(Flags & #ScrollBar_Top)>0 : YEnvW = Y + ScrollBarH : YScr = Y : Else : YEnvW = Y : YScr = Y + Height - ScrollBarH : EndIf 
  HEnvW = Height - ScrollBarH 
 Else : YEnvW = Y : YScr = Y : HEnvW = Height : EndIf 
 ScrollGadgets()\VisW = WEnvW - 2*BorderW : ScrollGadgets()\VisH = HEnvW - 2*BorderH 
 
 If (ClientW < (Width - 2*BorderW - (sbVActive*ScrollBarW) ) ) 
  ScrollGadgets()\SizeX = Width - 2*BorderW - (sbVActive*ScrollBarW) 
 Else : ScrollGadgets()\SizeX = ClientW : EndIf 
 If (ClientH < (Height - 2*BorderH - (sbHActive*ScrollBarH) ) ) 
  ScrollGadgets()\SizeY = Height - 2*BorderH - (sbHActive*ScrollBarH) 
 Else : ScrollGadgets()\SizeY = ClientH : EndIf 

 params\cbSize = SizeOf(SCROLLINFO) 
 params\fMask = #SIF_DISABLENOSCROLL | #SIF_PAGE | #SIF_POS | #SIF_RANGE 
 params\nMin = 0 
 params\nMax = ClientW 
 params\nPage = ScrollGadgets()\VisW 
 params\nPos = -ScrollGadgets()\PosX 
 SendMessage_(ScrollGadgets()\hScrollH, #SBM_SETSCROLLINFO, #TRUE, @params) 

 params\cbSize = SizeOf(SCROLLINFO) 
 params\fMask = #SIF_DISABLENOSCROLL | #SIF_PAGE | #SIF_POS | #SIF_RANGE 
 params\nMin = 0 
 params\nMax = ClientH 
 params\nPage = ScrollGadgets()\VisH 
 params\nPos = -ScrollGadgets()\PosY 
 SendMessage_(ScrollGadgets()\hScrollV, #SBM_SETSCROLLINFO, #TRUE, @params) 

 If scrollgadgets()\hide:hide=#SWP_HIDEWINDOW:Else:hide=#SWP_SHOWWINDOW:EndIf

 
 SetWindowPos_(ScrollGadgets()\hEnv, 0, XEnvW, YEnvW, WEnvW, HEnvW, #SWP_NOACTIVATE | #SWP_NOOWNERZORDER | #SWP_NOZORDER | hide) 
 SetWindowPos_(ScrollGadgets()\hWindow, 0, ScrollGadgets()\PosX, ScrollGadgets()\PosY, ScrollGadgets()\SizeX, ScrollGadgets()\SizeY, #SWP_NOACTIVATE & 0 | #SWP_NOOWNERZORDER | #SWP_NOZORDER | hide) 

 scrollgadgets()\hideV=sbvactive: scrollgadgets()\hideH=sbhactive

 If(sbVActive) 
  SetWindowPos_(ScrollGadgets()\hScrollV, #NULL, XScr, YEnvW, ScrollBarW, HEnvW,#SWP_NOACTIVATE | #SWP_NOOWNERZORDER | #SWP_NOZORDER | hide) 
 Else 
  SetWindowPos_(ScrollGadgets()\hScrollV, #NULL, XScr, YEnvW, ScrollBarW, HEnvW,#SWP_NOACTIVATE | #SWP_NOOWNERZORDER | #SWP_NOZORDER | #SWP_HIDEWINDOW) 
 EndIf 
 If(sbHActive) 
  SetWindowPos_(ScrollGadgets()\hScrollH, #NULL, XEnvW, YScr, WEnvW, ScrollBarH,#SWP_NOACTIVATE | #SWP_NOOWNERZORDER | #SWP_NOZORDER | hide) 
 Else 
  SetWindowPos_(ScrollGadgets()\hScrollH, #NULL, XEnvW, YScr, WEnvW, ScrollBarH,#SWP_NOACTIVATE | #SWP_NOOWNERZORDER | #SWP_NOZORDER | #SWP_HIDEWINDOW) 
 EndIf 
 
 If IsWindowVisible_(ScrollGadgets()\hPB)
   ShowWindow_(ScrollGadgets()\hPB,#SW_SHOWNA)
 EndIf
 ProcedureReturn ScrollGadgets()\hWindow 
EndProcedure 

Procedure CloseScrollGadget() 
 Protected *pointer.l 
 UseGadgetList(ScrollGadgets()\hPB) 
 *pointer = *ScrollGadgets()\Previous 
 ChangeCurrentElement(ScrollGadgets(), *pointer) 
EndProcedure 

Procedure WindowCallback(WindowID, Message, wParam, lParam) 
 Result = #PB_ProcessPureBasicEvents 
 If windowid=WindowID(#window_main) 
   Select Message 
     Case #WM_GETMINMAXINFO
       result = 0
       *ptr.MINMAXINFO = lParam
       *ptr\ptMinTrackSize\x = min_main_WIDTH ; your min width
       *ptr\ptMinTrackSize\y = min_main_HEIGHT ; your min height
     Case #WM_SIZE 
       UseWindow(#window_main)
       Resize_mainwindow()
     Case #WM_Quit
       postmessage_(windowid,#WM_Close,0,0)
   EndSelect
 EndIf
 
 If CountList(scrollgadgets())>0
   Protected *pointer.l
   *pointer=@ScrollGadgets()
   ResetList(ScrollGadgets()) 
   Select message
    Case #WM_HSCROLL 
     If lParam <> #NULL 
      ResetList(ScrollGadgets()) 
      Repeat 
       ne = NextElement(ScrollGadgets()) 
      Until (ScrollGadgets()\hScrollH = lParam) Or (ne = #FALSE) 
      If ne<>#false
        wLow = PeekW(@wParam) 
        wHi = PeekW(@wParam+2) - 1 
        Select wLow 
         Case #SB_LINELEFT: ScrollGadgets()\PosX + 10 
           If(ScrollGadgets()\PosX > 0) : ScrollGadgets()\PosX = 1 : EndIf 
         Case #SB_LINERIGHT: ScrollGadgets()\PosX - 10 
           If(ScrollGadgets()\PosX < (-(ScrollGadgets()\SizeX - ScrollGadgets()\VisW) ) ) 
            ScrollGadgets()\PosX = - (ScrollGadgets()\SizeX - ScrollGadgets()\VisW) 
           EndIf 
         Case #SB_PAGELEFT: ScrollGadgets()\PosX + ScrollGadgets()\Width 
           If(ScrollGadgets()\PosX > 0) : ScrollGadgets()\PosX = 1 : EndIf 
         Case #SB_PAGERIGHT: ScrollGadgets()\PosX - ScrollGadgets()\Width 
           If(ScrollGadgets()\PosX < (-(ScrollGadgets()\SizeX - ScrollGadgets()\VisW) ) ) 
            ScrollGadgets()\PosX = - (ScrollGadgets()\SizeX - ScrollGadgets()\VisW) 
           EndIf 
         Case #SB_THUMBPOSITION : ScrollGadgets()\PosX = -wHi 
         Case #SB_THUMBTRACK : ScrollGadgets()\PosX = -wHi 
        EndSelect 
        SetWindowPos_(ScrollGadgets()\hWindow, 0, ScrollGadgets()\PosX, ScrollGadgets()\PosY, 0, 0, #SWP_NOACTIVATE | #SWP_NOOWNERZORDER | #SWP_NOSIZE | #SWP_NOZORDER | #SWP_SHOWWINDOW)     
        SetScrollPos_(ScrollGadgets()\hScrollH, #SB_CTL, -ScrollGadgets()\PosX, #TRUE) 
        result = 0
      EndIf
     EndIf 
  
    Case #WM_VSCROLL 
     If lParam <> #NULL 
      ResetList(ScrollGadgets()) 
      Repeat: ne = NextElement(ScrollGadgets()) 
      Until ScrollGadgets()\hScrollV = lParam Or ne = #FALSE 
      If ne<>#false
        wLow = PeekW(@wParam) 
        wHi = PeekW(@wParam+2) - 1 
        Select wLow 
         Case #SB_LINEUP 
          ScrollGadgets()\PosY + 10 
          If(ScrollGadgets()\PosY > 0) : ScrollGadgets()\PosY = 1 : EndIf 
         Case #SB_LINEDOWN 
          ScrollGadgets()\PosY - 10 
          If(ScrollGadgets()\PosY < (-(ScrollGadgets()\SizeY - ScrollGadgets()\VisH) ) ) 
           ScrollGadgets()\PosY = - (ScrollGadgets()\SizeY - ScrollGadgets()\VisH) 
          EndIf 
         Case #SB_PAGEUP 
          ScrollGadgets()\PosY + ScrollGadgets()\Height 
          If(ScrollGadgets()\PosY > 0) : ScrollGadgets()\PosY = 1 : EndIf 
         Case #SB_PAGEDOWN 
          ScrollGadgets()\PosY - ScrollGadgets()\Height 
          If(ScrollGadgets()\PosY < (-(ScrollGadgets()\SizeY - ScrollGadgets()\VisH) ) ) 
           ScrollGadgets()\PosY = - (ScrollGadgets()\SizeY - ScrollGadgets()\VisH) 
          EndIf 
         Case #SB_THUMBPOSITION : ScrollGadgets()\PosY = -wHi 
         Case #SB_THUMBTRACK : ScrollGadgets()\PosY = -wHi 
        EndSelect 
        SetWindowPos_(ScrollGadgets()\hWindow, 0, ScrollGadgets()\PosX, ScrollGadgets()\PosY, 0, 0, #SWP_NOACTIVATE | #SWP_NOOWNERZORDER | #SWP_NOSIZE | #SWP_NOZORDER | #SWP_SHOWWINDOW) 
        SetScrollPos_(ScrollGadgets()\hScrollV, #SB_CTL, -ScrollGadgets()\PosY, #TRUE) 
        result = 0
       EndIf 
     EndIf
   EndSelect 
   ChangeCurrentElement(ScrollGadgets(), *pointer) 
 EndIf
 ProcedureReturn Result 
EndProcedure
;- other stuff
;Thanks to El_Choni for help.
Global SaveRequester_Position
Procedure save_char_sub(*res.choosenresources,adr);f:
  PokeL(adr,*res\ShowColor\color1) :adr+4
  PokeL(adr,*res\ShowColor\color2) :adr+4
  PokeL(adr,*res\ShowColor\color3) :adr+4
  PokeL(adr,*res\ShowColor\color4) :adr+4
  PokeL(adr,*res\DefaultColor\color1) :adr+4
  PokeL(adr,*res\DefaultColor\color2) :adr+4
  PokeL(adr,*res\DefaultColor\color3) :adr+4
  PokeL(adr,*res\DefaultColor\color4) :adr+4
  PokeW(adr,*res\methode):adr+2
  For i=0 To 128*72-1
    PokeB(adr, *res\Bild[i]) :adr+1
  Next
  For i=0 To 255
    PokeL(adr, *res\farben[i]) :adr+4
  Next
  For i=0 To 255
    PokeB(adr, *res\zuordnung[i]) :adr+1
  Next
  PokeW(adr,*res\backline) :adr+2
  PokeS(adr,*res\name$,255) :adr+256
  ProcedureReturn adr
EndProcedure;f:
Procedure save_char(file$);f:
  set_message(language$(17),file$)
  result=0
  block=#choosenresources_sizeV2*7
  memory=AllocateMemory(0,block)
  If memory>0
    adr=memory
    adr=save_char_sub(koerper_res,adr)
    adr=save_char_sub(kopf_res,adr)
    adr=save_char_sub(haare_res,adr)
    adr=save_char_sub(anzug_res,adr)
    adr=save_char_sub(item1_res,adr)
    adr=save_char_sub(item2_res,adr)
    adr=save_char_sub(item3_res,adr)
    If CreatePack(file$)
      AddPackMemory(memory,block,9)
      result =1
      ClosePack()
    EndIf
    FreeMemory(0)
  Else
    MessageRequester(#title_main,language$(14),0)
  EndIf
  hide_message()
  ProcedureReturn result
EndProcedure;f:
Procedure load_char_sub(*res.choosenresources,adr,X);f:
  *res\ShowColor\color1=PeekL(adr) :adr+4
  *res\ShowColor\color2=PeekL(adr) :adr+4
  *res\ShowColor\color3=PeekL(adr) :adr+4
  *res\ShowColor\color4=PeekL(adr) :adr+4
  *res\DefaultColor\color1=PeekL(adr) :adr+4
  *res\DefaultColor\color2=PeekL(adr) :adr+4
  *res\DefaultColor\color3=PeekL(adr) :adr+4
  *res\DefaultColor\color4=PeekL(adr) :adr+4
  *res\methode=PeekW(adr):adr+2
  For i=0 To 128*72-1
    *res\Bild[i]=PeekB(adr) :adr+1
  Next
  For i=0 To 255
    *res\farben[i]=PeekL(adr) :adr+4
  Next
  For i=0 To 255
    *res\zuordnung[i]=PeekB(adr) :adr+1
  Next
  *res\backline=PeekW(adr) :adr+2
  If X
    *res\name$=PeekS(adr,255):adr+256
  EndIf
  ProcedureReturn adr
EndProcedure;f:
Procedure load_char(file$)
  result=0
  block=#choosenresources_size*7
  blockV2=#choosenresources_sizeV2*7
  ;mem$=Space(block)
  If OpenPack(file$)
    adr=NextPackFile()
    Select PackFileSize()
      Case block:  ok=#TRUE:name=#FALSE
      Case blockV2:ok=#TRUE:name=#TRUE
      Default:    ok=#FALSE:name=#FALSE
    EndSelect
    
    If ok
      adr=load_char_sub(koerper_res,adr,name)
      adr=load_char_sub(kopf_res,adr,name)
      adr=load_char_sub(haare_res,adr,name)
      adr=load_char_sub(anzug_res,adr,name)
      adr=load_char_sub(item1_res,adr,name)
      adr=load_char_sub(item2_res,adr,name)
      adr=load_char_sub(item3_res,adr,name)
      result=1
    EndIf
    ClosePack()
  EndIf
  ProcedureReturn result
EndProcedure
Procedure confirm_overwrite(file$)
  If FileSize(file$)<>-1
    If MessageRequester(#title_main,language$(19)+Chr(10)+GetFilePart(file$),#PB_MessageRequester_YesNo)=#IDYES
      ProcedureReturn 1
    Else
      ProcedureReturn 0
    EndIf
  Else
    ProcedureReturn 1
  EndIf
EndProcedure
Global SaveRequester_Position
Procedure.s SaveRequester(Title$,File$,Pattern$,Position,flags)
  result$=""
  file$=SaveFileRequester(title$,file$,pattern$,position)
  SaveRequester_Position=SelectedFilePattern() 
  If file$<>""
    If GetExtensionPart(file$)="" 
      d$=StringField(pattern$,SaveRequester_Position*2+2,"|")
      d$=GetExtensionPart(StringField(d$,1,";"))
      If d$<>"*"
        file$+"."+d$
      EndIf
    EndIf
    If confirm_overwrite(file$)
      result$=file$
    EndIf
  EndIf
  ProcedureReturn result$
EndProcedure
Procedure.s GetWithoutExtenstion(file$)
  ProcedureReturn  Left(file$,Len(file$)-Len(GetExtensionPart(file$))-1)
EndProcedure
Procedure Start_autobackcolor()
  backcolor=-1
  For i=0 To #autobackmax-1
    autoback(i)=0
  Next
  i=#autobackmax:  autoback(i)=1 ; bug in compiler
EndProcedure
Procedure set_autobackcolor(r,g,b)
  code=(((r>>#autobackdiv)<<#autobackmul)+(g>>#autobackdiv))<<#autobackmul + b>>#autobackdiv
  autoback(code)=1
EndProcedure
Procedure get_autobackcolor()
  autoback=-1:range=-9999
  start=-1:ende=-1
  For i=0 To #autobackmax
    If autoback(i)=0
      If start<0: start=i :EndIf
      ende=i
    Else
      If start=0:start=-ende:EndIf
      If ende=#autobackmax-1:ende=#autobackmax-1-start+#autobackmax-1:EndIf
      farb=(start+ende)>>1 ;/2
      weite=ende-start
      ;Debug Str(start)+" to "+Str(ende)+" = "+Str(farb)+" reichweite="+Str(weite)
      If weite>=range: autoback=farb:range=weite :EndIf
      start=-1:ende=-1
    EndIf
  Next
  
  If autoback=-1
    ProcedureReturn RGB(255,255,255)
  Else
    blau=(autoback&#autobackand)<<#autobackdiv
    autoback=autoback>>#autobackmul
    gruen=(autoback&#autobackand)<<#autobackdiv
    autoback=autoback>>#autobackmul
    rot=(autoback&#autobackand)<<#autobackdiv
    ProcedureReturn RGB(rot,gruen,blau)
  EndIf
EndProcedure
Procedure GetTextHeight(fontid)
  hdc=StartDrawing(WindowOutput())
  DrawingFont(fontid)
  tm.textmetric
  PrevMapMode=SetMapMode_(hdc,#mm_text)
  gettextmetrics_(hdc,tm)
  If prevmapmode
    setmapmode_(hdc,prevmapmode)
  EndIf
  StopDrawing()
  ProcedureReturn tm\tmHeight
EndProcedure
 
; CursorPosition=3
; CompileThis=F:\charas.ex\charas.ex.pb
; ExecutableFormat=Windows
; EOF